--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A widget containing properties specific to color previews.
--- @class tes3uiColorPreview : tes3uiWidget
--- @field alpha number The current alpha value of the preview.
--- @field checkerboard Image *Read-only*. The checkerboard image used by the preview element.
--- @field checkerSize integer|nil *Read-only*. The size of individual square in the color preview image in pixels.
--- @field color ffiImagePixel The current color of the preview.
--- @field darkGray mwseColorTable|nil *Read-only*. The color of darker squares in the color preview image.
--- @field height integer *Read-only*. The height of the individual preview element.
--- @field image Image *Read-only*. The image used by the preview element.
--- @field lightGray mwseColorTable|nil *Read-only*. The color of lighter squares in the color preview image.
--- @field texture niSourceTexture *Read-only*. The texture used by the preview element.
--- @field width integer *Read-only*. The width of the individual preview element.
tes3uiColorPreview = {}

--- Gets the current alpha value.
--- @return number alpha No description yet available.
function tes3uiColorPreview:getAlpha() end

--- Gets the current color of the preview.
--- @return mwseColorTable color No description yet available.
function tes3uiColorPreview:getColor() end

--- Gets the current color and alpha.
--- @return mwseColorTable color No description yet available.
--- @return number alpha No description yet available.
function tes3uiColorPreview:getColorAlpha() end

--- Gets the current color and alpha in a single table.
--- @return mwseColorATable color No description yet available.
function tes3uiColorPreview:getRGBA() end

--- Changes the color of this widget to given color.
--- @param newColor mwseColorTable|ffiImagePixel The new color to set.
--- @param alpha? number *Default*: `1`. Alpha value to set.
function tes3uiColorPreview:setColor(newColor, alpha) end

